<?php

spl_autoload_register(function ($class_name) {
    $path = __DIR__ . '/classes/' . $class_name . '.php';
    if (file_exists($path)) {
        include $path;
    }
});

// Retrieve and use preferences
$admin = false;

// Set default preferences 
if (!isset($_COOKIE['user_prefs'])) {
    $preferences = ['theme' => 'light', 'role' => 'user'];
    setcookie('user_prefs', serialize($preferences), time() + 3600, "/"); // Set cookie for 1 hour
} else {
    // Read user preferences
    $preferences = @unserialize($_COOKIE['user_prefs']); 

    if ($preferences && isset($preferences['role']) && $preferences['role'] === 'admin') {
        $admin = true;
    }
}
?>