route.get("/api/env", (req, res) => {
    
    const cookieHeader = req.headers.cookie;

    if (!cookieHeader) {
        return res.status(403).json({ error: "access denied" });
    }

    const cookies = {};
    cookieHeader.split(';').forEach(cookie => {
        const [key, ...val] = cookie.trim().split('=');
        cookies[key] = val.join('=');
    });

    const accessToken = cookies['access_token'];

    if (accessToken === '<ADMIN_BOT_COOKIE>') {
        return res.json({ flag: "<FLAG>" });
    } else {
        return res.status(403).json({ error: "access denied" });
    }
});

// @author Siam Thanat Hack Co., Ltd. (STH)
// We provide professional pentest service :)
//   - Website: https://sth.sh
//   - LINE: @siamthanathack
//   - Email: pentest@sth.sh