app.post('/redeem', (req, res) => {
    if (!req.session.user) {
        return res.status(401).json({ success: false, message: 'User not logged in' });
    }

    const { code } = req.body;

    if (!code) {
        return res.status(400).json({ success: false, message: 'Gift card code is required.' });
    }


    const checkSql = 'SELECT * FROM giftcardcode WHERE code = ?';
    connection.query(checkSql, [code], (err, results) => {
        if (err) {
            console.error('Error querying the database:', err.stack);
            return res.status(500).json({ success: false, message: 'Database error.' });
        }

        if (results.length === 0) {
            return res.status(404).json({ success: false, message: 'Gift card code not found.' });
        }

        const giftCard = results[0];

        if (giftCard.used === 1) {
            return res.status(400).json({ success: false, message: 'This gift card has already been redeemed.' });
        }


        const redeemSql = 'UPDATE giftcardcode SET used = 1 WHERE code = ?';
        connection.query(redeemSql, [code], (err, updateResult) => {
            if (err) {
                console.error('Error updating gift card status:', err.stack);
                return res.status(500).json({ success: false, message: 'Error updating gift card status.' });
            }

            const updateBalanceSql = 'UPDATE users SET balance = balance + 1000 WHERE username = ?';
            connection.query(updateBalanceSql, [req.session.user.username], (err, balanceResult) => {
                if (err) {
                    console.error('Error updating user balance:', err.stack);
                    return res.status(500).json({ success: false, message: 'Error updating user balance.' });
                }

                return res.status(200).json({ success: true, message: 'Gift card redeemed successfully! Balance updated.' });
            });
        });
    });
});

// @author Siam Thanat Hack Co., Ltd. (STH)
// We provide professional pentest service :)
//   - Website: https://sth.sh
//   - LINE: @siamthanathack
//   - Email: pentest@sth.sh